% created by Nils Hase 2016 (nilshase@math.uni-bremen.de)

% Sparse dictionary regularization with dictionary configured for the US
% setup; the problem solved is
%
% [c_opt,alpha_opt] = arg min 1/2 ||ADc-y||_2^2 + alpha ||c||_1
%
% The optimal regularization parameter is chosen by Morozov's discrepancy
% principle

function [x_opt,alpha_opt,D,c_opt] = FISTA_DIC(A,y,alpha,plotter)
    
    % Load sparse dictionary matrix
    load('dictionary.mat','D')
    
    c_0 = zeros(size(D,2),1);
    
    [c_opt,alpha_opt] = FISTA_L1(A*D,y,c_0,alpha,plotter);
    x_opt = D*c_opt;

end
